-------------------------------------------------------------------------------------------------------------------
-- REVISION 6 LUA Scripts (Ov3rHell3XoduZ)
-- Branches Library for METRO QUAD.
-------------------------------------------------------------------------------------------------------------------

-------------------------------------------------------------------------------------------------------------------
-- Branches for ScreenInit.
-------------------------------------------------------------------------------------------------------------------
ScreenInit = {
	NextScreen = function()
		if GAMESTATE:GetCoinMode() == 'CoinMode_Home' then
			return Branch.TitleMenu()
		else
			return "ScreenCompany"
		end
	end
}

-------------------------------------------------------------------------------------------------------------------
-- Branches for ScreenTitleMenu.
-------------------------------------------------------------------------------------------------------------------
ScreenTitle = {
	StartGame = function()
		local NextScreen
		
		if SONGMAN:GetNumSongs() == 0 and SONGMAN:GetNumAdditionalSongs() == 0 then
			return "ScreenHowToInstallSongs"
		else
			NextScreen = "ScreenSelectProfile"
		end
	
		return NextScreen
	end,
	ChoiceScreen = function()
		local online = IsNetConnected()
		if online then return "ScreenSMOnlineLogin" else return "ScreenProfileLoad" end
	end,
}

-------------------------------------------------------------------------------------------------------------------
-- Branches for ScreenSelectProfile.
-------------------------------------------------------------------------------------------------------------------
ScreenProfile = {
	NextScreen = function()
		return "ScreenSelectStyle"
	end
}

-------------------------------------------------------------------------------------------------------------------
-- Branches for ScreenSelectStyle.
-------------------------------------------------------------------------------------------------------------------
ScreenStyle = {
	AfterSelectStyle = function()
		if IsNetConnected() then
			ReportStyle()
			GAMESTATE:ApplyGameCommand("playmode,regular")
		end
		if IsNetSMOnline() then
			return SMOnlineScreen()
		end
		if IsNetConnected() then
			return "ScreenNetRoom"
		end
		GAMESTATE:ApplyGameCommand("playmode,regular")
		return "ScreenSelectMusic"
	end
}

-------------------------------------------------------------------------------------------------------------------
-- Branches for ScreenProfileLoad.
-------------------------------------------------------------------------------------------------------------------
ScreenProfileLoad = {
	NextScreen = function()
		local cm = GAMESTATE:IsCourseMode()
		if cm then return "ScreenSelectCourse"
		else return "ScreenSelectMusic" end
	end
}

-------------------------------------------------------------------------------------------------------------------
-- Branches for ScreenSelectMusic.
-------------------------------------------------------------------------------------------------------------------
ScreenMusic = {
	NextScreen = function()
		if SCREENMAN:GetTopScreen():GetGoToOptions() then
			return "ScreenPlayerOptions"
		else
			return "ScreenGameplay"
		end
	end
}

-------------------------------------------------------------------------------------------------------------------
-- Branches for ScreenPlayerOptions.
-------------------------------------------------------------------------------------------------------------------
PlayerOptions = {
	PrevScreen = function()
		if GAMESTATE:IsCourseMode() then
			return "ScreenSelectCourse"
		else
			return "ScreenSelectMusic"
		end
	end
}